@extends('layouts.app')

@section('title', 'Home')

@section('content')
<div class="home-page">
    <div class="hero-section">
        <div class="container">
            <div class="search-container">
                <h1>How can we help you?</h1>
                <form action="{{ route('knowledgebase') }}" method="GET" class="search-form">
                    <input type="text" name="search" placeholder="Search for answers..." class="search-input">
                    <button type="submit" class="search-button">Search</button>
                </form>
            </div>
            
            @auth
                <div class="create-ticket-section">
                    <a href="{{ route('tickets.create') }}" class="btn btn-primary btn-large">Create Ticket</a>
                </div>
            @else
                <div class="create-ticket-section">
                    <a href="{{ route('register') }}" class="btn btn-primary btn-large">Create Ticket</a>
                </div>
            @endauth
        </div>
    </div>

    <div class="knowledge-base-section">
        <div class="container">
            <h2>Knowledge Base</h2>
            <div class="knowledge-base-grid">
                @forelse($knowledgeBaseItems as $item)
                    <div class="knowledge-base-card">
                        <h3>{{ $item->title }}</h3>
                        <p>{{ Str::limit($item->content, 150) }}</p>
                        <a href="{{ route('knowledgebase') }}#{{ $item->id }}" class="read-more">Read More →</a>
                    </div>
                @empty
                    <div class="knowledge-base-card">
                        <p>No knowledge base articles available yet.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection

